import json
from pathlib import Path
from scipy.stats.mstats import gmean

logs_path = 'logs_miplib_small'

method_name = 'TreeGate-p'              # 3179.55 3179.55
method_name = 'TreeGate'                # 2171.31 2205.06
method_name = 'Mamba-Branching-p'       # 2272.43 2272.43
method_name = 'Mamba-Branching'         # 2054.99 2077.55
method_name = 'Mamba-Branching-p-ncl'   # 3000.92 3000.92
method_name = 'Transformer-Branching'   # 3078.56 3120.04
method_name = 'Transformer-Branching-p' # 5138.15 5138.15

logs_path = 'logs_miplib_large'
method_name = 'easy-Mamba-Branching'    # 1819.32 2053.91
method_name = 'hard-Mamba-Branching'    # 12319.55

all_fair_nnodes_list = []
all_pd_integral_list = []
all_nnodes_list = []
for seed in range(5):
    
    info_seed_list = [
        str(path) for path  in Path(
            f"./{logs_path}/{method_name}"
        ).glob(f'*_{seed}.json')
    ]
        
    
    data_list = []
    for info in info_seed_list:
        with open(info, 'r') as f:
            data = json.load(f)
        data_list.append(data)
        print(f"name: {data['name']} seed:{data['seed']} fair_nnodes:{data['fair_nnodes']}")

    
    
    fair_nnodes_list = []
    pd_integral_list = []
    nnodes_list = []
    for data in data_list:
        fair_nnodes_list.append(data['fair_nnodes'])
        pd_integral_list.append(data['primaldualintegral']) 
        nnodes_list.append(data['nnodes'])

    all_fair_nnodes_list.extend(fair_nnodes_list)
    all_pd_integral_list.extend(pd_integral_list)
    all_nnodes_list.extend(nnodes_list)
    
    print("")
    print(f"instance num: {len(fair_nnodes_list)}")
    print(f"seed:{seed} gmean fair_nnodes: {gmean(fair_nnodes_list)} pd integral: {gmean(pd_integral_list)}")
    print("")

print(f'Overall nnodes: {gmean(all_nnodes_list) :.2f}')
print(f"Overall fair_nnodes: {gmean(all_fair_nnodes_list) :.2f}")
print(f"Overall pd integral: {gmean(all_pd_integral_list) :.2f}")
    